---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Inertia (diagnostic)

> Resistance to change of Form under intended reconfiguration; minimal "force/time" to shift identity.

---

## Definition

- Change resistance level
- Form stability force
- Identity hold strength
- Update effort need

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Change resist | State hold | `Monitor`, `Hold` |
| Form force | Shape keep | `Check`, `Force` |
| Update need | Change cost | `Test`, `Cost` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Change resist | Hard to move | "Won't budge" |
| Form force | Stays same | "Keeps shape" |
| Update need | Change work | "Takes effort" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| State hold | Hard to move | How resist works |
| Shape keep | Stays same | How form stays |
| Change cost | Change work | How effort flows |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Mass hold | Force need |
| Networks | State keep | Link hold |
| Cognition | Mind stay | Think hold |
| Systems | Flow resist | Change work |

---

## Scale Effects

How Inertia manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum hold | Wave stay |
| λV | Gate resist | State keep |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase hold | Pattern stay |
| ∇S | Structure keep | Clear hold |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave resist | Light hold |
| λV | Field keep | Space stay |

Note: At extreme scales, inertia faces fundamental limits (e.g., quantum uncertainty at ε, causal resistance at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: change minimum
- c: update speed
- ψA: hold strength
- λV: gate resist

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern hold | Wave stay |
| Human | λV | Gate resist | Flow keep |
| Cosmic | ψA | Phase keep | Field hold |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Too rigid | Pattern stuck | Won't move |
| Human | Too loose | Flow wild | No hold |
| Cosmic | Bad hold | Field drift | Lost stay |

---

## Diagnostic Checklist

Technical tests:
- [ ] Hold measured
- [ ] Force right
- [ ] Cost known
- [ ] Change tracked

Humane tests:
- [ ] Move possible
- [ ] Shape stable
- [ ] Work clear
- [ ] Change flows

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical resistance nor experiential effort alone captures its full meaning.

---

## See Also

- [[Robustness (diagnostic)]]
- [[Resilience (diagnostic)]]
- [[Overbound Awareness (classification)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented